<?php
/**
* @package icarus
* @subpackage form-markup-generator
*/

/**
* require parent file
*/
require_once field_markup_generator_path('field_group');
require_once field_markup_generator_path('integer_text_input');

/**
* @package icarus
* @subpackage form-markup-generator
*/
class Social_security_number_markup_generator extends Field_group_markup_generator{
	protected $_type = 'social_security_number';
	protected $_field_templates = array(//note that area numbers may not be 000, 666, or in the range of 900-999 (see: http://en.wikipedia.org/wiki/Social_security_number#Structure)
										'area_number' => array('type' => 'integer_text_input', 'minimum' => 000, 'maximum' => 999, 'min_length' => 3, 'attributes' => array('size' => 3), 
															   'label_attributes' => array('class' => 'sr-only'), 'feedback_invalid_input' => 'Please enter a three digit number for the %s field.'),
										'group_number' => array('type' => 'integer_text_input', 'minimum' => 000, 'maximum' => 99, 'min_length' => 2, 'attributes' => array('size' => 2),
												  			    'label_attributes' => array('class' => 'sr-only'), 'feedback_invalid_input' => 'Please enter a two digit number for the %s field.'),
										'serial_number' => array('type' => 'integer_text_input', 'minimum' => 0000, 'maximum' => 9999, 'min_length' => 4,  'attributes' => array('size' => 4),
												  			     'label_attributes' => array('class' => 'sr-only'), 'feedback_invalid_input' => 'Please enter a four digit number for the %s field.'));



	function value(){
		$values = $this->values();	
		
		//check to make sure that we have values - if all three values are an empty string, just return the empty string
		if(count(array_unique($values)) === 1 && first_element($values) === ''){
			return '';
		}
		
		$number_lengths = array('area_number' => 3, 'group_number' => 2, 'serial_number' => 4);
		foreach($values as $field_name => $field_value){
			if($this->has_field($field_name) && is_numeric($field_value))
				$values[$field_name] = str_pad($field_value, $number_lengths[$field_name], '0', STR_PAD_LEFT);
		} 
				
		return implode('-', $values);
	}

	function set_required($value){
		//makes sure that the required value for this group applies to all of the fields in the group
		$this->_required = $value;
		if(isset($this->fields) && !empty($this->fields)){
			foreach($this->fields as $field_name => $field){
				$this->field($field_name)->required = $value;
			}
		}
		else{
			//if we don't have the fields yet, apply the required value to the field templates
			foreach($this->_field_templates as $field_name => $info){
				if(!is_array($info)) $info = array('type' => $info);
				$this->_field_templates[$field_name]['required'] = $value;
			}
		}
	}

	function set_value($value){
		if($this->validator->string_like_a_social_security_number($value)){
			$pieces = explode('-', $value);
			$value = array('area_number' => $pieces[0], 'group_number' => $pieces[1], 'serial_number' => $pieces[2]);	
		}
		if(is_array($value)) $this->set_values($value);
	}
	
/*	function set_values($values){
		$number_lengths = array('area_number' => 3, 'group_number' => 2, 'serial_number' => 4);
		foreach($values as $field_name => $field_value){
			if($this->has_field($field_name) && is_numeric($field_value))
				$values[$field_name] = str_pad($field_value, $number_lengths[$field_name], '0', STR_PAD_LEFT);
		} 
		return parent::set_values($values);
	} */
	
	function has_valid_value_if_any(){
		//if any of the fields are filled out, all of them are required
		if(!$this->field('area_number')->property_is_empty('value') || !$this->field('group_number')->property_is_empty('value') || !$this->field('serial_number')->property_is_empty('value')){
			$this->field('area_number')->required = true;
			$this->field('group_number')->required = true;
			$this->field('serial_number')->required = true;
		}

		return parent::has_valid_value_if_any();
	}

}